within Modelica.Magnetic.FluxTubes.UsersGuide;
class Literature "Literature"
  extends Modelica.Icons.References;

  annotation (Documentation(info="<html>
<h4>Literature</h4>
<ul>
<li><strong> Usage of the Modelica Magnetic library is described in:</strong>

<br><table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td>[B&ouml;08]</td>
      <td>B&ouml;drich, T.:
        <em>Electromagnetic Actuator Modelling with the Extended Modelica Magnetic Library</em>,
        Modelica 2008 Conference, Bielefeld, Germany,pp. 221-227, March 3-4, 2008. Download from: <a href=\"https://www.modelica.org/events/modelica2008/Proceedings/sessions/session2d2.pdf\">https://www.modelica.org/events/modelica2008/&shy;Proceedings/sessions/session2d2.pdf</a></td>
    </tr>
</table><br>

</li>
<li><strong>The method of magnetic flux tubes as well as derivation of the permeance of many flux tube shapes is explained in detail in:</strong>

<br><table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td>[Ro41]</td>
      <td>Roters, H.:
        <em>Electromagnetic Devices</em>,
        New York: John Wiley &amp; Sons 1941 (8th Printing 1961)</td>
    </tr>
</table><br>
</li>

<li><strong>Structure, properties, applications and design of electromagnetic (reluctance type) actuators are thoroughly described in:</strong>

<br><table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td>[KEQ+12]</td>
      <td>Kallenbach, E.; Eick, R.; Quendt, P.; Str&ouml;hla, T.; Feindt, K.; Kallenbach, M.; Radler, O.:
        <em>Elektromagnete: Grundlagen, Berechnung, Entwurf und Anwendung</em>,
        3rd ed., Wiesbaden: Vieweg Teubner 2008 (in German).</td>
    </tr>

    <tr>
      <td>[Ro00]</td>
      <td>Roschke, T.:
        <em>Entwurf geregelter elektromagnetischer Antriebe f&uuml;r Luftsch&uuml;tze</em>,
        Fortschritt-Berichte VDI, Reihe 21, Nr. 293, D&uuml;sseldorf: VDI-Verlag 2000 (in German).</td>
    </tr>
</table><br>
</li>

<li><strong> Application of the method of magnetic flux tubes to the design of rotational electrical machines is explained for example in:</strong>

<br><table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td>[HM94]</td>
      <td>Hendershot, J.R. Jr.; Miller, T.J.E.:
        <em>Design of Brushless Permanent-Magnet Motors</em>,
        Magna Physics Publishing and Oxford University Press 1994.</td>
    </tr>
</table><br>
</li>

<li><strong>Information related to the implemented hysteresis models can be found in:</strong>

<br><table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">
    <tr>
      <td>[BE01]</td>
      <td>Bergqvist, A. J.; Engdahl, S. G.:
        <em>A Homogenization Procedure of Field Quantities in Laminated Electric Steel</em>,
        IEEE Transactions on Magnetics, vol.37, no.5, pp.3329-3331, 2001.</td>
    </tr>
    <tr>
      <td>[Te98]</td>
      <td>Tellinen, J:
        <em>A simple scalar model for magnetic hysteresis</em>,
        IEEE Translation Journal on Magnetics in Japan, vol.4, no.6, pp.353-359, 1989.</td>
    </tr>
    <tr>
      <td>[Pr35]</td>
      <td>Preisach, F.:
        <em>&Uuml;ber die magnetische Nachwirkung</em>,
        Zeitschrift f&uuml;r Physik A Hadrons and Nuclei, vol. 94, pp. 277-302, 1935.</td>
    </tr>
    <tr>
      <td>[Ma03]</td>
      <td>Mayergoyz, I.:
        <em>Mathematical Models of Hysteresis and their Application</em>,
        Elsevier, 2003.</td>
    </tr>
    <tr>
      <td>[Va01]</td>
      <td>VAC Vacuumschmelze:
        <em>Soft Magnetic Cobalt-Iron-Alloys</em>, 2001.
        Download from: <a href=\"http://www.vacuumschmelze.com/fileadmin/docroot/medialib/documents/broschueren/htbrosch/Pht-004_e.pdf\">http://www.vacuumschmelze.com/fileadmin/&shy;docroot/medialib/documents/&shy;broschueren/htbrosch/Pht-004_e.pdf</a></td>
    </tr>
    <tr>
      <td>[YUY89]</td>
      <td>Yamaguchi, T.; Ueda, F.; Yamamoto, E.:
        <em>Simulation of Hysteresis Characteristics of Core Materials Using the Everett Function</em>,
        IEEE Translation Journal on Magnetics in Japan, vol.4, no.6, pp.353-359, 1989.</td>
    </tr>
    <tr>
      <td>[ZB12]</td>
      <td>Ziske, J.; B&ouml;drich, T.:
        <em>Magnetic Hysteresis Models for Modelica</em>,
        Proc. of the 9th Modelica Conference, Munich, Germany, pp. 151-158, September 3-5, 2012. Download from: <a href=\"http://www.ep.liu.se/ecp/076/014/ecp12076014.pdf\">http://www.ep.liu.se/ecp/&shy;076/014/ecp12076014.pdf</a></td>
    </tr>
    <tr>
      <td>[ZB14]</td>
      <td>Ziske, J.; B&ouml;drich, T.:
        <em>http://www.ep.liu.se/ecp/096/017/ecp14096017.pdf</em>,
        Proc. of the 10th Modelica Conference, Lund, Sweden, pp. 165-172, March 10-12, 2014. Download from: <a href=\"http://www.ep.liu.se/ecp/096/017/ecp14096017.pdf\">http://www.ep.liu.se/ecp/&shy;096/017/ecp14096017.pdf</a></td>
    </tr>

</table><br>
</li>

</ul>

</html>"));
end Literature;
